#include<iostream.h>
#include<memory.h>
#include<string.h>
#include<fstream.h>
#include<assert.h>


//---------------------------------- C A R  C L A S S ---------------------------------

template <class DATATYPE>

class Car
{
	private:
		DATATYPE* License_Plate_Number;
		int car_movement;
		int car_movement_counter;

	public:

		Car() : License_Plate_Number(NULL) , car_movement(0) , car_movement_counter(0)
		{	}

		void Set_License_Plate_Number(const DATATYPE* Plate_Number)
		{
			License_Plate_Number=new DATATYPE[8];
			assert(License_Plate_Number!=NULL);

			strcpy(License_Plate_Number,Plate_Number);
		}

		void increase()
		{
			car_movement=++car_movement_counter;
		}

		int Get_Car_Movement_Number()
		{
			return car_movement;
		}

		DATATYPE* Get_License_Plate_Number()
		{
			return License_Plate_Number;
		}

		~Car()
		{
			if (License_Plate_Number!=NULL)
				delete [] License_Plate_Number;

			car_movement=0; 
			car_movement_counter=0;
		}
};

template <class DATATYPE>

//------------------------------- G A R A G E  C L A S S ---------------------------------

class Garage
{
	private:
		Car<DATATYPE> * cars;		
		int Maximum_Cars;
		int Present_Cars;

	public:

		Garage() : Maximum_Cars(0) , Present_Cars(0)
		{	}

		Garage(int num)
		{	
			cars = new Car<DATATYPE>[num];
			Maximum_Cars=num;
			Present_Cars=0;
		}

		void Push(const DATATYPE* value, int val)
		{
			cars[++Present_Cars].Set_License_Plate_Number(value);			

			if (val==1)
				cars[Present_Cars].increase();			
		}

		DATATYPE* Pop ()
		{				
			DATATYPE* name=cars[Present_Cars].Get_License_Plate_Number();
			Present_Cars--;
			return name;
		}

		int Get_Total_Cars()
		{
			return Maximum_Cars;
		}

		int Get_Present_Cars()
		{
			return Present_Cars;
		}

		DATATYPE* Get_License_Number() 
		{
			return cars[Present_Cars].Get_License_Plate_Number();
		}

		int Get_Car_movement(const DATATYPE* Plate_Number)
		{
			for (int i=1 ; i<=Present_Cars ; i++)
			{
				if (strcmp(cars[i].Get_License_Plate_Number(),Plate_Number))
				{	}
				else
					return cars[i].Get_Car_Movement_Number();
			}			

			return 0;
		}

		~Garage() 
		{			
			Maximum_Cars=0;
			Present_Cars=0;
		}
};

int main(int argc , char* args[])
{
	if (argc<3)
	{
		cerr<<"INVALID NUMBER OF ARGUMENTS";
		return 1;
	}	
	
	//open file stream for the input and output
	ifstream inFile(args[1], ios::in);		

	//open file stream for the input and output	
	ofstream outFile(args[2], ios::out);

	//checks that the output file is open or not
	if (!outFile)
	{
		cerr<<"unable to open the output file"<<endl;
		return 2;
	}

	//checks that the input file is open or not
	if (!inFile)
	{
		cerr<<"unable to open the input file"<<endl;
		return 3;
	}

	int Maximum_No_of_Cars,movement;
	char check;
	char* License_Plate_Number;
	License_Plate_Number=new char[8];

	inFile>>Maximum_No_of_Cars;

	Garage<char> Garage01(Maximum_No_of_Cars);		

	for(int k=1; k<=5; k++)
	{

	inFile>>check;	
		
	switch(check)
	{
		case 'A':
			{
				inFile>>License_Plate_Number;
				Garage01.Push(License_Plate_Number,0);

				outFile<<" ARRIVAL "<<Garage01.Get_License_Number();

				if ((Garage01.Get_Total_Cars()-Garage01.Get_Present_Cars())!=0)
					outFile<<" There is room "<<endl;

				else
					outFile<<" There is no room "<<endl;

				break;
			}

		case 'D':
			{
				Garage<char> Spare_Stack(Maximum_No_of_Cars);	

				inFile>>License_Plate_Number;
				int no_of_cars_to_be_moved=0;				
				int num=Garage01.Get_Present_Cars();
				bool checking=false;

				for (int j=0 ; j<num ; j++)
				{
				
				movement=Garage01.Get_Car_movement(License_Plate_Number);
				char* Current_Car=Garage01.Pop();								

				if (strcmp(Current_Car,License_Plate_Number))
				{	
					++no_of_cars_to_be_moved;
					Spare_Stack.Push(Current_Car,0);
				}
				else
				{
					int num=Spare_Stack.Get_Present_Cars();
					for(int i=1; i<=num ; i++)
					{						
						char* name=Spare_Stack.Pop();
						Garage01.Push(name,1);
						checking=true;
					}
				}
				if (checking==true)
					break;
				}


				outFile<<" DEPARTURE "<<License_Plate_Number;
				
				outFile<<" Car has moved "<<movement<<" times , "<<no_of_cars_to_be_moved<<" cars are to be moved ."<<endl;

				break;
			}		
	}
	}
	return 0;
}